import type { Config } from 'tailwindcss'

const config: Config = {
  content: [
    './pages/**/*.{js,ts,jsx,tsx,mdx}',
    './components/**/*.{js,ts,jsx,tsx,mdx}',
    './app/**/*.{js,ts,jsx,tsx,mdx}',
  ],
  theme: {
    extend: {
      colors: {
        primary: {
          DEFAULT: '#6c4d80',
          dark: '#5a3f6d',
          light: '#7d5e91',
          50: '#f5f1f7',
          100: '#ebe3ef',
          200: '#d7c7df',
          300: '#c3abcf',
          400: '#af8fbf',
          500: '#6c4d80',
          600: '#563e66',
          700: '#412e4d',
          800: '#2b1f33',
          900: '#160f1a',
        },
        secondary: {
          DEFAULT: '#0b233e',
          dark: '#081a2e',
          light: '#0f2d4e',
          50: '#e7ebef',
          100: '#cfd7df',
          200: '#9fafbf',
          300: '#6f879f',
          400: '#3f5f7f',
          500: '#0b233e',
          600: '#091c32',
          700: '#071525',
          800: '#040e19',
          900: '#02070c',
        },
        accent: {
          DEFAULT: '#6c4d80',
          dark: '#5a3f6d',
          light: '#7d5e91',
          50: '#f5f1f7',
          100: '#ebe3ef',
          200: '#d7c7df',
          300: '#c3abcf',
          400: '#af8fbf',
          500: '#6c4d80',
          600: '#563e66',
          700: '#412e4d',
          800: '#2b1f33',
          900: '#160f1a',
        },
        error: {
          DEFAULT: '#B63A3A',
          dark: '#992f2f',
          light: '#c85050',
        },
        background: {
          DEFAULT: '#f8f8f8',
          surface: '#ffffff',
          card: '#ffffff',
          elevated: '#f0f0f0',
          dark: '#0b233e',
        },
        text: {
          primary: '#0b233e',
          secondary: '#4a5568',
          muted: '#718096',
          light: '#ffffff',
        },
        border: {
          DEFAULT: '#e2e8f0',
          light: '#edf2f7',
          accent: '#6c4d8033',
        },
      },
      fontFamily: {
        sans: ['Inter', 'system-ui', '-apple-system', 'BlinkMacSystemFont', 'Segoe UI', 'Roboto', 'sans-serif'],
        display: ['Inter', 'system-ui', 'sans-serif'],
      },
      fontSize: {
        '2xs': ['0.625rem', { lineHeight: '0.875rem' }],
        'display-lg': ['4rem', { lineHeight: '1.1', letterSpacing: '-0.02em' }],
        'display-md': ['3rem', { lineHeight: '1.15', letterSpacing: '-0.02em' }],
        'display-sm': ['2.25rem', { lineHeight: '1.2', letterSpacing: '-0.01em' }],
      },
      boxShadow: {
        'glow-sm': '0 0 15px -3px rgba(108, 77, 128, 0.15)',
        'glow-md': '0 0 25px -5px rgba(108, 77, 128, 0.2)',
        'glow-lg': '0 0 40px -8px rgba(108, 77, 128, 0.25)',
        'glow-accent': '0 0 30px rgba(108, 77, 128, 0.3)',
        'glow-primary': '0 0 30px rgba(108, 77, 128, 0.4)',
        'glow-secondary': '0 0 30px rgba(11, 35, 62, 0.4)',
        'card': '0 1px 3px rgba(0,0,0,0.08), 0 1px 2px rgba(0,0,0,0.12)',
        'card-hover': '0 10px 40px rgba(0,0,0,0.15), 0 15px 12px rgba(0,0,0,0.1)',
        'elevated': '0 20px 60px -15px rgba(0, 0, 0, 0.25)',
        'inner-glow': 'inset 0 1px 0 0 rgba(255,255,255,0.1)',
      },
      backgroundImage: {
        'gradient-radial': 'radial-gradient(var(--tw-gradient-stops))',
        'gradient-conic': 'conic-gradient(from 180deg at 50% 50%, var(--tw-gradient-stops))',
        'hero-glow': 'radial-gradient(ellipse 80% 50% at 50% -20%, rgba(108, 77, 128, 0.15), transparent)',
        'mesh-gradient': 'radial-gradient(at 40% 20%, rgba(108, 77, 128, 0.2) 0px, transparent 50%), radial-gradient(at 80% 0%, rgba(11, 35, 62, 0.15) 0px, transparent 50%), radial-gradient(at 0% 50%, rgba(108, 77, 128, 0.1) 0px, transparent 50%)',
        'glass-gradient': 'linear-gradient(135deg, rgba(255,255,255,0.1) 0%, rgba(255,255,255,0.05) 100%)',
        'border-gradient': 'linear-gradient(135deg, rgba(108, 77, 128, 0.4), rgba(11, 35, 62, 0.3), rgba(108, 77, 128, 0.4))',
        'card-shine': 'linear-gradient(135deg, rgba(255,255,255,0.15) 0%, transparent 50%, transparent 100%)',
        'brand-gradient': 'linear-gradient(135deg, #6c4d80 0%, #0b233e 100%)',
        'brand-gradient-reverse': 'linear-gradient(135deg, #0b233e 0%, #6c4d80 100%)',
      },
      animation: {
        'fade-in': 'fadeIn 0.5s ease-out',
        'fade-in-up': 'fadeInUp 0.6s ease-out',
        'fade-in-down': 'fadeInDown 0.6s ease-out',
        'slide-in-left': 'slideInLeft 0.5s ease-out',
        'slide-in-right': 'slideInRight 0.5s ease-out',
        'scale-in': 'scaleIn 0.3s ease-out',
        'float': 'float 6s ease-in-out infinite',
        'glow-pulse': 'glowPulse 2s ease-in-out infinite',
        'shimmer': 'shimmer 2s linear infinite',
        'gradient-shift': 'gradientShift 8s ease infinite',
        'gradient': 'gradient 8s ease infinite',
        'spin-slow': 'spin 20s linear infinite',
        'bounce-subtle': 'bounceSubtle 2s ease-in-out infinite',
        'pulse-subtle': 'pulseSubtle 3s ease-in-out infinite',
      },
      keyframes: {
        fadeIn: {
          '0%': { opacity: '0' },
          '100%': { opacity: '1' },
        },
        fadeInUp: {
          '0%': { opacity: '0', transform: 'translateY(20px)' },
          '100%': { opacity: '1', transform: 'translateY(0)' },
        },
        fadeInDown: {
          '0%': { opacity: '0', transform: 'translateY(-20px)' },
          '100%': { opacity: '1', transform: 'translateY(0)' },
        },
        slideInLeft: {
          '0%': { opacity: '0', transform: 'translateX(-30px)' },
          '100%': { opacity: '1', transform: 'translateX(0)' },
        },
        slideInRight: {
          '0%': { opacity: '0', transform: 'translateX(30px)' },
          '100%': { opacity: '1', transform: 'translateX(0)' },
        },
        scaleIn: {
          '0%': { opacity: '0', transform: 'scale(0.95)' },
          '100%': { opacity: '1', transform: 'scale(1)' },
        },
        float: {
          '0%, 100%': { transform: 'translateY(0) rotate(0deg)' },
          '50%': { transform: 'translateY(-15px) rotate(2deg)' },
        },
        glowPulse: {
          '0%, 100%': { boxShadow: '0 0 20px rgba(108, 77, 128, 0.2)' },
          '50%': { boxShadow: '0 0 40px rgba(108, 77, 128, 0.4)' },
        },
        shimmer: {
          '0%': { backgroundPosition: '-200% 0' },
          '100%': { backgroundPosition: '200% 0' },
        },
        gradientShift: {
          '0%, 100%': { backgroundPosition: '0% 50%' },
          '50%': { backgroundPosition: '100% 50%' },
        },
        gradient: {
          '0%, 100%': { backgroundPosition: '0% 50%' },
          '50%': { backgroundPosition: '100% 50%' },
        },
        bounceSubtle: {
          '0%, 100%': { transform: 'translateY(0)' },
          '50%': { transform: 'translateY(-5px)' },
        },
        pulseSubtle: {
          '0%, 100%': { opacity: '1' },
          '50%': { opacity: '0.8' },
        },
      },
      transitionTimingFunction: {
        'bounce-in': 'cubic-bezier(0.68, -0.55, 0.265, 1.55)',
        'smooth': 'cubic-bezier(0.4, 0, 0.2, 1)',
        'smooth-out': 'cubic-bezier(0, 0, 0.2, 1)',
      },
      backdropBlur: {
        xs: '2px',
      },
      borderRadius: {
        '4xl': '2rem',
        '5xl': '2.5rem',
      },
      spacing: {
        '18': '4.5rem',
        '88': '22rem',
        '112': '28rem',
        '128': '32rem',
      },
    },
  },
  plugins: [],
}
export default config
