'use client'

import Link from 'next/link'

export default function SecurityPage() {
  const services = [
    "Providing more timely warning on potential risks to NGO operations in South Sudan",
    "Provide 24/7 response to emergent security issues",
    "Provide flash and daily incident updates",
    "Provide weekly and monthly security analysis reports",
    "Manage incident database",
    "Provide weekly security briefing",
    "Coordinate NGO security-based relocations",
    "Conduct outreach activities to support field NGOs",
    "Manage and coordinate information sharing platforms",
    "Conduct external liaison with security / safety network"
  ]

  return (
    <div className="min-h-screen bg-background">
      {/* Hero Section */}
      <section className="relative bg-gradient-to-br from-primary via-primary-light to-primary py-20 overflow-hidden">
        <div className="absolute inset-0 bg-[radial-gradient(ellipse_80%_50%_at_50%_-20%,rgba(255,255,255,0.15),transparent)]" />
        <div className="absolute inset-0 opacity-10">
          <div className="absolute top-10 left-10 w-32 h-32 border border-white/30 rounded-full" />
          <div className="absolute bottom-10 right-10 w-24 h-24 border border-white/20 rounded-full" />
        </div>
        <div className="container mx-auto px-4 relative z-10">
          <div className="max-w-4xl">
            <Link href="/what-we-do" className="inline-flex items-center gap-2 text-white/80 hover:text-white mb-6 transition-colors">
              <svg className="w-5 h-5" fill="none" viewBox="0 0 24 24" stroke="currentColor">
                <path strokeLinecap="round" strokeLinejoin="round" strokeWidth={2} d="M10 19l-7-7m0 0l7-7m-7 7h18" />
              </svg>
              Back to What We Do
            </Link>
            <h1 className="text-4xl md:text-5xl lg:text-6xl font-bold text-white mb-4">
              SAFETY AND SECURITY
            </h1>
            <div className="h-1 w-24 bg-white/50 rounded-full" />
          </div>
        </div>
      </section>

      {/* Content Section */}
      <section className="py-16 lg:py-24">
        <div className="container mx-auto px-4">
          <div className="max-w-4xl mx-auto">
            {/* Mission */}
            <div className="mb-16">
              <h2 className="text-3xl font-bold text-primary mb-6">MISSION</h2>
              <p className="text-lg text-secondary/80 leading-relaxed">
                Support the NGO Forum with information sharing, analysis, advice and guidance in order to enhance situational awareness, inform operational decision-making and help enable humanitarian activity.
              </p>
            </div>

            {/* Services */}
            <div>
              <h2 className="text-3xl font-bold text-primary mb-8">SERVICES</h2>
              <ul className="space-y-4">
                {services.map((service, index) => (
                  <li key={index} className="flex items-start gap-4">
                    <div className="w-2 h-2 rounded-full bg-primary mt-2 flex-shrink-0" />
                    <p className="text-secondary/80 leading-relaxed">{service}</p>
                  </li>
                ))}
              </ul>
            </div>

            {/* Emergency Contact */}
            <div className="mt-16 p-8 bg-gradient-to-br from-red-50 to-red-100/50 rounded-3xl border border-red-200">
              <div className="flex items-start gap-4">
                <div className="w-12 h-12 rounded-xl bg-red-500 flex items-center justify-center flex-shrink-0">
                  <svg className="w-6 h-6 text-white" fill="none" viewBox="0 0 24 24" stroke="currentColor">
                    <path strokeLinecap="round" strokeLinejoin="round" strokeWidth={2} d="M12 9v2m0 4h.01m-6.938 4h13.856c1.54 0 2.502-1.667 1.732-3L13.732 4c-.77-1.333-2.694-1.333-3.464 0L3.34 16c-.77 1.333.192 3 1.732 3z" />
                  </svg>
                </div>
                <div>
                  <h3 className="text-xl font-bold text-red-800 mb-2">24/7 Security Support</h3>
                  <p className="text-red-700 mb-4">
                    For emergent security issues, our team is available around the clock to provide support and guidance.
                  </p>
                  <Link
                    href="/contact"
                    className="inline-flex items-center gap-2 px-6 py-3 bg-red-600 text-white rounded-xl font-semibold hover:bg-red-700 transition-colors"
                  >
                    Contact Security Team
                    <svg className="w-5 h-5" fill="none" viewBox="0 0 24 24" stroke="currentColor">
                      <path strokeLinecap="round" strokeLinejoin="round" strokeWidth={2} d="M17 8l4 4m0 0l-4 4m4-4H3" />
                    </svg>
                  </Link>
                </div>
              </div>
            </div>
          </div>
        </div>
      </section>
    </div>
  )
}
