'use client'

import Link from 'next/link'

export default function PolicyPage() {
  const services = [
    "Share with members relevant policies and formal communications that touch on NGOs operations in South Sudan",
    "Engage with authorities on implementation of formal policies and statutes",
    "Engage with members for inputs that shape polices and laws",
    "Forging strong working relationships with relevant duty bearers in South Sudan",
    "Share and engage with relevant stakeholders best practices in policy development and implementation",
    "Advocate and represent collective interests of members to relative stakeholders and duty bearers"
  ]

  return (
    <div className="min-h-screen bg-background">
      {/* Hero Section */}
      <section className="relative bg-gradient-to-br from-primary via-primary-light to-primary py-20 overflow-hidden">
        <div className="absolute inset-0 bg-[radial-gradient(ellipse_80%_50%_at_50%_-20%,rgba(255,255,255,0.15),transparent)]" />
        <div className="absolute inset-0 opacity-10">
          <div className="absolute top-10 left-10 w-32 h-32 border border-white/30 rounded-full" />
          <div className="absolute bottom-10 right-10 w-24 h-24 border border-white/20 rounded-full" />
        </div>
        <div className="container mx-auto px-4 relative z-10">
          <div className="max-w-4xl">
            <Link href="/what-we-do" className="inline-flex items-center gap-2 text-white/80 hover:text-white mb-6 transition-colors">
              <svg className="w-5 h-5" fill="none" viewBox="0 0 24 24" stroke="currentColor">
                <path strokeLinecap="round" strokeLinejoin="round" strokeWidth={2} d="M10 19l-7-7m0 0l7-7m-7 7h18" />
              </svg>
              Back to What We Do
            </Link>
            <h1 className="text-4xl md:text-5xl lg:text-6xl font-bold text-white mb-4">
              POLICY
            </h1>
            <div className="h-1 w-24 bg-white/50 rounded-full" />
          </div>
        </div>
      </section>

      {/* Content Section */}
      <section className="py-16 lg:py-24">
        <div className="container mx-auto px-4">
          <div className="max-w-4xl mx-auto">
            {/* Mission */}
            <div className="mb-16">
              <h2 className="text-3xl font-bold text-primary mb-6">MISSION</h2>
              <p className="text-lg text-secondary/80 leading-relaxed">
                To ensure that formal policies and guidelines support NGO operations and service delivery to South Sudan population through the representation, communication and public messaging function, the forum engages in relevant fora.
              </p>
            </div>

            {/* Services */}
            <div>
              <h2 className="text-3xl font-bold text-primary mb-8">SERVICES</h2>
              <ul className="space-y-4">
                {services.map((service, index) => (
                  <li key={index} className="flex items-start gap-4">
                    <div className="w-2 h-2 rounded-full bg-primary mt-2 flex-shrink-0" />
                    <p className="text-secondary/80 leading-relaxed">{service}</p>
                  </li>
                ))}
              </ul>
            </div>

            {/* Policy Resources */}
            <div className="mt-16 grid md:grid-cols-2 gap-6">
              <div className="p-6 bg-white rounded-2xl border border-border hover:border-primary/30 hover:shadow-lg transition-all duration-300">
                <div className="w-12 h-12 rounded-xl bg-primary/10 flex items-center justify-center mb-4">
                  <svg className="w-6 h-6 text-primary" fill="none" viewBox="0 0 24 24" stroke="currentColor">
                    <path strokeLinecap="round" strokeLinejoin="round" strokeWidth={2} d="M9 12h6m-6 4h6m2 5H7a2 2 0 01-2-2V5a2 2 0 012-2h5.586a1 1 0 01.707.293l5.414 5.414a1 1 0 01.293.707V19a2 2 0 01-2 2z" />
                  </svg>
                </div>
                <h3 className="text-lg font-bold text-secondary mb-2">Policy Documents</h3>
                <p className="text-secondary/60 text-sm mb-4">Access our collection of policy briefs and position papers.</p>
                <Link href="/resources" className="text-primary font-semibold text-sm hover:text-primary-light transition-colors">
                  View Resources →
                </Link>
              </div>
              <div className="p-6 bg-white rounded-2xl border border-border hover:border-primary/30 hover:shadow-lg transition-all duration-300">
                <div className="w-12 h-12 rounded-xl bg-primary/10 flex items-center justify-center mb-4">
                  <svg className="w-6 h-6 text-primary" fill="none" viewBox="0 0 24 24" stroke="currentColor">
                    <path strokeLinecap="round" strokeLinejoin="round" strokeWidth={2} d="M8 12h.01M12 12h.01M16 12h.01M21 12c0 4.418-4.03 8-9 8a9.863 9.863 0 01-4.255-.949L3 20l1.395-3.72C3.512 15.042 3 13.574 3 12c0-4.418 4.03-8 9-8s9 3.582 9 8z" />
                  </svg>
                </div>
                <h3 className="text-lg font-bold text-secondary mb-2">Policy Discussions</h3>
                <p className="text-secondary/60 text-sm mb-4">Join conversations on policy matters affecting NGOs.</p>
                <Link href="/forum" className="text-primary font-semibold text-sm hover:text-primary-light transition-colors">
                  Join Forum →
                </Link>
              </div>
            </div>
          </div>
        </div>
      </section>
    </div>
  )
}
