'use client'

import Link from 'next/link'

export default function WhatWeDoPage() {
  const sections = [
    {
      title: "Information Sharing",
      description: "Collect and disseminate relevant information on decisions and changes that affect operations of members in South Sudan.",
      icon: "📢",
      href: "/what-we-do/information-sharing",
      color: "from-blue-500 to-blue-600"
    },
    {
      title: "Safety & Security",
      description: "Support the NGO Forum with information sharing, analysis, advice and guidance to enhance situational awareness and inform operational decision-making.",
      icon: "🛡️",
      href: "/what-we-do/security",
      color: "from-red-500 to-red-600"
    },
    {
      title: "Policy",
      description: "Ensure that formal policies and guidelines support NGO operations and service delivery through representation and advocacy.",
      icon: "📋",
      href: "/what-we-do/policy",
      color: "from-purple-500 to-purple-600"
    },
    {
      title: "External Engagement",
      description: "Facilitate NGOs delivery of humanitarian and development outcomes through joint working with members, authorities, donors, and UN agencies.",
      icon: "🤝",
      href: "/what-we-do/external-engagement",
      color: "from-green-500 to-green-600"
    },
    {
      title: "INGO-NNGO Networking",
      description: "Enhancement of NGOs posture and National NGOs (NNGOs) capacity strengthening for improved delivery of programs.",
      icon: "🔗",
      href: "/what-we-do/ingo-nngo-networking",
      color: "from-orange-500 to-orange-600"
    }
  ]

  return (
    <div className="min-h-screen bg-background">
      {/* Hero Section */}
      <section className="relative bg-gradient-to-br from-primary via-primary-light to-primary py-20 lg:py-32 overflow-hidden">
        <div className="absolute inset-0 bg-[radial-gradient(ellipse_80%_50%_at_50%_-20%,rgba(255,255,255,0.15),transparent)]" />
        <div className="absolute inset-0 opacity-10">
          <div className="absolute top-10 left-10 w-32 h-32 border border-white/30 rounded-full animate-pulse" />
          <div className="absolute bottom-10 right-10 w-24 h-24 border border-white/20 rounded-full animate-pulse" style={{ animationDelay: '1s' }} />
          <div className="absolute top-1/2 right-1/4 w-16 h-16 border border-white/25 rounded-full animate-pulse" style={{ animationDelay: '0.5s' }} />
        </div>
        <div className="container mx-auto px-4 relative z-10">
          <div className="max-w-4xl mx-auto text-center">
            <h1 className="text-4xl md:text-5xl lg:text-6xl font-bold text-white mb-6">
              What We Do
            </h1>
            <p className="text-xl text-white/80 max-w-2xl mx-auto">
              The South Sudan NGO Forum works across five key areas to support and coordinate humanitarian and development action in South Sudan.
            </p>
          </div>
        </div>
      </section>

      {/* Sections Grid */}
      <section className="py-16 lg:py-24">
        <div className="container mx-auto px-4">
          <div className="grid md:grid-cols-2 lg:grid-cols-3 gap-8">
            {sections.map((section, index) => (
              <Link
                key={index}
                href={section.href}
                className="group relative bg-white rounded-3xl p-8 border border-border hover:border-primary/30 hover:shadow-2xl hover:shadow-primary/10 transition-all duration-500 hover:-translate-y-2"
              >
                {/* Icon */}
                <div className={`w-16 h-16 rounded-2xl bg-gradient-to-br ${section.color} flex items-center justify-center mb-6 group-hover:scale-110 transition-transform duration-300`}>
                  <span className="text-3xl">{section.icon}</span>
                </div>

                {/* Content */}
                <h3 className="text-xl font-bold text-secondary mb-3 group-hover:text-primary transition-colors">
                  {section.title}
                </h3>
                <p className="text-secondary/60 leading-relaxed mb-6">
                  {section.description}
                </p>

                {/* Arrow */}
                <div className="flex items-center text-primary font-semibold">
                  Learn More
                  <svg className="w-5 h-5 ml-2 group-hover:translate-x-2 transition-transform duration-300" fill="none" viewBox="0 0 24 24" stroke="currentColor">
                    <path strokeLinecap="round" strokeLinejoin="round" strokeWidth={2} d="M17 8l4 4m0 0l-4 4m4-4H3" />
                  </svg>
                </div>

                {/* Decorative gradient */}
                <div className={`absolute top-0 right-0 w-32 h-32 bg-gradient-to-br ${section.color} opacity-5 rounded-full blur-2xl -translate-y-1/2 translate-x-1/2`} />
              </Link>
            ))}
          </div>
        </div>
      </section>

      {/* Overview Section */}
      <section className="py-16 lg:py-24 bg-gradient-to-br from-secondary/5 to-primary/5">
        <div className="container mx-auto px-4">
          <div className="max-w-4xl mx-auto text-center">
            <h2 className="text-3xl font-bold text-secondary mb-6">Our Approach</h2>
            <p className="text-lg text-secondary/70 mb-12 leading-relaxed">
              The NGO Forum serves as the coordinating body for non-governmental organizations operating in South Sudan. 
              Through our five pillars of work, we facilitate collaboration, share critical information, advocate for 
              enabling policies, and strengthen the capacity of our members to deliver effective humanitarian and 
              development assistance.
            </p>

            <div className="grid md:grid-cols-3 gap-8">
              <div className="text-center">
                <div className="w-20 h-20 rounded-full bg-primary/10 flex items-center justify-center mx-auto mb-4">
                  <span className="text-4xl">🤝</span>
                </div>
                <h3 className="font-bold text-secondary mb-2">Coordination</h3>
                <p className="text-secondary/60 text-sm">Bringing NGOs together for effective action</p>
              </div>
              <div className="text-center">
                <div className="w-20 h-20 rounded-full bg-primary/10 flex items-center justify-center mx-auto mb-4">
                  <span className="text-4xl">📣</span>
                </div>
                <h3 className="font-bold text-secondary mb-2">Advocacy</h3>
                <p className="text-secondary/60 text-sm">Representing the collective NGO voice</p>
              </div>
              <div className="text-center">
                <div className="w-20 h-20 rounded-full bg-primary/10 flex items-center justify-center mx-auto mb-4">
                  <span className="text-4xl">💪</span>
                </div>
                <h3 className="font-bold text-secondary mb-2">Capacity Building</h3>
                <p className="text-secondary/60 text-sm">Strengthening NGO effectiveness</p>
              </div>
            </div>
          </div>
        </div>
      </section>

      {/* CTA Section */}
      <section className="py-16 lg:py-24">
        <div className="container mx-auto px-4">
          <div className="max-w-4xl mx-auto bg-gradient-to-br from-primary to-primary-light rounded-3xl p-8 lg:p-12 text-center text-white">
            <h2 className="text-3xl font-bold mb-4">Want to Learn More?</h2>
            <p className="text-white/80 mb-8 max-w-2xl mx-auto">
              Contact our team to learn how the NGO Forum can support your organization&apos;s work in South Sudan.
            </p>
            <div className="flex flex-col sm:flex-row gap-4 justify-center">
              <Link
                href="/contact"
                className="inline-flex items-center justify-center gap-2 px-8 py-4 bg-white text-primary rounded-xl font-bold hover:bg-white/90 transition-colors"
              >
                Contact Us
              </Link>
              <Link
                href="/apply"
                className="inline-flex items-center justify-center gap-2 px-8 py-4 border-2 border-white text-white rounded-xl font-bold hover:bg-white/10 transition-colors"
              >
                Become a Member
              </Link>
            </div>
          </div>
        </div>
      </section>
    </div>
  )
}
