'use client'

import Link from 'next/link'

export default function INGONNGONetworkingPage() {
  const services = [
    "Information sharing on best practices in humanitarian and development programmes delivery",
    "Offering training and mentoring opportunities to members and range of stakeholders for effective programming",
    "Internal networking among NNGOs and with INGOs and with donors and other stakeholders",
    "Capacity development of national NGOs.",
    "Peer-pairing and sharing information on funding opportunities.",
    "NNGOs system strengthening.",
    "Internship Programme.",
    "State Coordination Support.",
    "National NGOs Annual Exposition."
  ]

  return (
    <div className="min-h-screen bg-background">
      {/* Hero Section */}
      <section className="relative bg-gradient-to-br from-primary via-primary-light to-primary py-20 overflow-hidden">
        <div className="absolute inset-0 bg-[radial-gradient(ellipse_80%_50%_at_50%_-20%,rgba(255,255,255,0.15),transparent)]" />
        <div className="absolute inset-0 opacity-10">
          <div className="absolute top-10 left-10 w-32 h-32 border border-white/30 rounded-full" />
          <div className="absolute bottom-10 right-10 w-24 h-24 border border-white/20 rounded-full" />
        </div>
        <div className="container mx-auto px-4 relative z-10">
          <div className="max-w-4xl">
            <Link href="/what-we-do" className="inline-flex items-center gap-2 text-white/80 hover:text-white mb-6 transition-colors">
              <svg className="w-5 h-5" fill="none" viewBox="0 0 24 24" stroke="currentColor">
                <path strokeLinecap="round" strokeLinejoin="round" strokeWidth={2} d="M10 19l-7-7m0 0l7-7m-7 7h18" />
              </svg>
              Back to What We Do
            </Link>
            <h1 className="text-4xl md:text-5xl lg:text-6xl font-bold text-white mb-4">
              INGO-NNGO NETWORKING
            </h1>
            <p className="text-xl text-white/80 mt-4">
              AND CAPACITY DEVELOPMENT
            </p>
            <div className="h-1 w-24 bg-white/50 rounded-full mt-4" />
          </div>
        </div>
      </section>

      {/* Content Section */}
      <section className="py-16 lg:py-24">
        <div className="container mx-auto px-4">
          <div className="max-w-4xl mx-auto">
            {/* Mission */}
            <div className="mb-16">
              <h2 className="text-3xl font-bold text-primary mb-6">MISSION</h2>
              <p className="text-lg text-secondary/80 leading-relaxed">
                Enhancement of NGOs posture and National NGOs (NNGOs) capacity strengthening for improved delivery of programs.
              </p>
            </div>

            {/* Services */}
            <div>
              <h2 className="text-3xl font-bold text-primary mb-8">SERVICES</h2>
              <ul className="space-y-4">
                {services.map((service, index) => (
                  <li key={index} className="flex items-start gap-4">
                    <div className="w-2 h-2 rounded-full bg-primary mt-2 flex-shrink-0" />
                    <p className="text-secondary/80 leading-relaxed">{service}</p>
                  </li>
                ))}
              </ul>
            </div>

            {/* Key Programs */}
            <div className="mt-16 grid md:grid-cols-3 gap-6">
              <div className="p-6 bg-white rounded-2xl border border-border hover:border-primary/30 hover:shadow-lg transition-all duration-300 text-center">
                <div className="w-16 h-16 rounded-full bg-primary/10 flex items-center justify-center mx-auto mb-4">
                  <svg className="w-8 h-8 text-primary" fill="none" viewBox="0 0 24 24" stroke="currentColor">
                    <path strokeLinecap="round" strokeLinejoin="round" strokeWidth={2} d="M12 6.253v13m0-13C10.832 5.477 9.246 5 7.5 5S4.168 5.477 3 6.253v13C4.168 18.477 5.754 18 7.5 18s3.332.477 4.5 1.253m0-13C13.168 5.477 14.754 5 16.5 5c1.747 0 3.332.477 4.5 1.253v13C19.832 18.477 18.247 18 16.5 18c-1.746 0-3.332.477-4.5 1.253" />
                  </svg>
                </div>
                <h3 className="text-lg font-bold text-secondary mb-2">Training Programs</h3>
                <p className="text-secondary/60 text-sm">Capacity building workshops and training for NNGO staff</p>
              </div>
              <div className="p-6 bg-white rounded-2xl border border-border hover:border-primary/30 hover:shadow-lg transition-all duration-300 text-center">
                <div className="w-16 h-16 rounded-full bg-primary/10 flex items-center justify-center mx-auto mb-4">
                  <svg className="w-8 h-8 text-primary" fill="none" viewBox="0 0 24 24" stroke="currentColor">
                    <path strokeLinecap="round" strokeLinejoin="round" strokeWidth={2} d="M17 20h5v-2a3 3 0 00-5.356-1.857M17 20H7m10 0v-2c0-.656-.126-1.283-.356-1.857M7 20H2v-2a3 3 0 015.356-1.857M7 20v-2c0-.656.126-1.283.356-1.857m0 0a5.002 5.002 0 019.288 0M15 7a3 3 0 11-6 0 3 3 0 016 0zm6 3a2 2 0 11-4 0 2 2 0 014 0zM7 10a2 2 0 11-4 0 2 2 0 014 0z" />
                  </svg>
                </div>
                <h3 className="text-lg font-bold text-secondary mb-2">Peer Pairing</h3>
                <p className="text-secondary/60 text-sm">INGO-NNGO partnerships for knowledge transfer</p>
              </div>
              <div className="p-6 bg-white rounded-2xl border border-border hover:border-primary/30 hover:shadow-lg transition-all duration-300 text-center">
                <div className="w-16 h-16 rounded-full bg-primary/10 flex items-center justify-center mx-auto mb-4">
                  <svg className="w-8 h-8 text-primary" fill="none" viewBox="0 0 24 24" stroke="currentColor">
                    <path strokeLinecap="round" strokeLinejoin="round" strokeWidth={2} d="M21 13.255A23.931 23.931 0 0112 15c-3.183 0-6.22-.62-9-1.745M16 6V4a2 2 0 00-2-2h-4a2 2 0 00-2 2v2m4 6h.01M5 20h14a2 2 0 002-2V8a2 2 0 00-2-2H5a2 2 0 00-2 2v10a2 2 0 002 2z" />
                  </svg>
                </div>
                <h3 className="text-lg font-bold text-secondary mb-2">Internship Program</h3>
                <p className="text-secondary/60 text-sm">Opportunities for young professionals in the sector</p>
              </div>
            </div>

            {/* CTA */}
            <div className="mt-16 p-8 bg-gradient-to-br from-primary/5 to-primary/10 rounded-3xl border border-primary/20 text-center">
              <h3 className="text-xl font-bold text-secondary mb-4">Join Our Network</h3>
              <p className="text-secondary/70 mb-6 max-w-2xl mx-auto">
                Whether you&apos;re an INGO looking to partner or an NNGO seeking capacity development support, we&apos;re here to help you connect and grow.
              </p>
              <div className="flex flex-col sm:flex-row gap-4 justify-center">
                <Link
                  href="/apply"
                  className="inline-flex items-center justify-center gap-2 px-6 py-3 bg-primary text-white rounded-xl font-semibold hover:bg-primary-light transition-colors"
                >
                  Become a Member
                  <svg className="w-5 h-5" fill="none" viewBox="0 0 24 24" stroke="currentColor">
                    <path strokeLinecap="round" strokeLinejoin="round" strokeWidth={2} d="M17 8l4 4m0 0l-4 4m4-4H3" />
                  </svg>
                </Link>
                <Link
                  href="/contact"
                  className="inline-flex items-center justify-center gap-2 px-6 py-3 border-2 border-primary text-primary rounded-xl font-semibold hover:bg-primary/5 transition-colors"
                >
                  Contact Us
                </Link>
              </div>
            </div>
          </div>
        </div>
      </section>
    </div>
  )
}
