'use client'

import Link from 'next/link'

export default function InformationSharingPage() {
  const services = [
    "Collect, store and disseminate relevant information pertaining to humanitarian action, recovery and development activities and policies.",
    "Collect, store and disseminate relevant government publications, announcements, and circulars following up with the appropriate line ministries to ensure that they are understandable to the NGO audience.",
    "Collect, store and disseminate calls for proposals from donors.",
    "Disseminate job vacancies from donors, UN Agencies, and NGOs to stakeholders.",
    "Attend and disseminate minutes/notes of meetings in which the NGO Forum is invited to participate (i.e. pooled funding oversight committees, UN HCTs, donor fora, UN Security Management Team etc.).",
    "Publish weekly update to the Country Director's Group.",
    "Disseminate information on public / special events.",
    "Maintain and disseminate a contact directory of different stakeholders for NGOs where appropriate.",
    "Prepare and publish briefings on issues of common interest to the NGO Forum as defined by the Steering Committee.",
    "Support NNGOs in diagnosing institutional gaps and strengths as well as generate quantitative information to inform NNGO capacity status discussions.",
    "Support, publicise and/or organize training opportunities for members and/or stakeholders."
  ]

  return (
    <div className="min-h-screen bg-background">
      {/* Hero Section */}
      <section className="relative bg-gradient-to-br from-primary via-primary-light to-primary py-20 overflow-hidden">
        <div className="absolute inset-0 bg-[radial-gradient(ellipse_80%_50%_at_50%_-20%,rgba(255,255,255,0.15),transparent)]" />
        <div className="absolute inset-0 opacity-10">
          <div className="absolute top-10 left-10 w-32 h-32 border border-white/30 rounded-full" />
          <div className="absolute bottom-10 right-10 w-24 h-24 border border-white/20 rounded-full" />
        </div>
        <div className="container mx-auto px-4 relative z-10">
          <div className="max-w-4xl">
            <Link href="/what-we-do" className="inline-flex items-center gap-2 text-white/80 hover:text-white mb-6 transition-colors">
              <svg className="w-5 h-5" fill="none" viewBox="0 0 24 24" stroke="currentColor">
                <path strokeLinecap="round" strokeLinejoin="round" strokeWidth={2} d="M10 19l-7-7m0 0l7-7m-7 7h18" />
              </svg>
              Back to What We Do
            </Link>
            <h1 className="text-4xl md:text-5xl lg:text-6xl font-bold text-white mb-4">
              INFORMATION SHARING
            </h1>
            <div className="h-1 w-24 bg-white/50 rounded-full" />
          </div>
        </div>
      </section>

      {/* Content Section */}
      <section className="py-16 lg:py-24">
        <div className="container mx-auto px-4">
          <div className="max-w-4xl mx-auto">
            {/* Mission */}
            <div className="mb-16">
              <h2 className="text-3xl font-bold text-primary mb-6">MISSION</h2>
              <p className="text-lg text-secondary/80 leading-relaxed">
                Collect and disseminate relevant information on decisions and changes that affect operations of members in South Sudan.
              </p>
            </div>

            {/* Services */}
            <div>
              <h2 className="text-3xl font-bold text-primary mb-8">SERVICES</h2>
              <ul className="space-y-4">
                {services.map((service, index) => (
                  <li key={index} className="flex items-start gap-4">
                    <div className="w-2 h-2 rounded-full bg-primary mt-2 flex-shrink-0" />
                    <p className="text-secondary/80 leading-relaxed">{service}</p>
                  </li>
                ))}
              </ul>
            </div>

            {/* Contact CTA */}
            <div className="mt-16 p-8 bg-gradient-to-br from-primary/5 to-primary/10 rounded-3xl border border-primary/20">
              <h3 className="text-xl font-bold text-secondary mb-4">Need More Information?</h3>
              <p className="text-secondary/70 mb-6">
                Contact our team to learn more about our information sharing services and how we can support your organization.
              </p>
              <Link
                href="/contact"
                className="inline-flex items-center gap-2 px-6 py-3 bg-primary text-white rounded-xl font-semibold hover:bg-primary-light transition-colors"
              >
                Contact Us
                <svg className="w-5 h-5" fill="none" viewBox="0 0 24 24" stroke="currentColor">
                  <path strokeLinecap="round" strokeLinejoin="round" strokeWidth={2} d="M17 8l4 4m0 0l-4 4m4-4H3" />
                </svg>
              </Link>
            </div>
          </div>
        </div>
      </section>
    </div>
  )
}
