'use client'

import Link from 'next/link'

export default function ExternalEngagementPage() {
  const services = [
    "Represent members voice and concerns to relevant partners, duty bearers and donors",
    "Providing technical assistance support to NNGOs",
    "Facilitating dialogue and workshops; promoting networking",
    "Discuss implications of changes in operational context on NGO work with key stakeholders",
    "Reach-out and disseminate relevant messages on NGO work in South Sudan",
    "Peer reviews and analysis",
    "Forge and amplify good working relationships with actors that impact NGO work in South Sudan"
  ]

  return (
    <div className="min-h-screen bg-background">
      {/* Hero Section */}
      <section className="relative bg-gradient-to-br from-primary via-primary-light to-primary py-20 overflow-hidden">
        <div className="absolute inset-0 bg-[radial-gradient(ellipse_80%_50%_at_50%_-20%,rgba(255,255,255,0.15),transparent)]" />
        <div className="absolute inset-0 opacity-10">
          <div className="absolute top-10 left-10 w-32 h-32 border border-white/30 rounded-full" />
          <div className="absolute bottom-10 right-10 w-24 h-24 border border-white/20 rounded-full" />
        </div>
        <div className="container mx-auto px-4 relative z-10">
          <div className="max-w-4xl">
            <Link href="/what-we-do" className="inline-flex items-center gap-2 text-white/80 hover:text-white mb-6 transition-colors">
              <svg className="w-5 h-5" fill="none" viewBox="0 0 24 24" stroke="currentColor">
                <path strokeLinecap="round" strokeLinejoin="round" strokeWidth={2} d="M10 19l-7-7m0 0l7-7m-7 7h18" />
              </svg>
              Back to What We Do
            </Link>
            <h1 className="text-4xl md:text-5xl lg:text-6xl font-bold text-white mb-4">
              EXTERNAL ENGAGEMENTS
            </h1>
            <div className="h-1 w-24 bg-white/50 rounded-full" />
          </div>
        </div>
      </section>

      {/* Content Section */}
      <section className="py-16 lg:py-24">
        <div className="container mx-auto px-4">
          <div className="max-w-4xl mx-auto">
            {/* Mission */}
            <div className="mb-16">
              <h2 className="text-3xl font-bold text-primary mb-6">MISSION</h2>
              <p className="text-lg text-secondary/80 leading-relaxed">
                Facilitate NGOs delivery of humanitarian and development outcomes through joint working with members, authorities, donors, UN agencies and observers.
              </p>
            </div>

            {/* Services */}
            <div>
              <h2 className="text-3xl font-bold text-primary mb-8">SERVICES</h2>
              <ul className="space-y-4">
                {services.map((service, index) => (
                  <li key={index} className="flex items-start gap-4">
                    <div className="w-2 h-2 rounded-full bg-primary mt-2 flex-shrink-0" />
                    <p className="text-secondary/80 leading-relaxed">{service}</p>
                  </li>
                ))}
              </ul>
            </div>

            {/* Partners Section */}
            <div className="mt-16 p-8 bg-gradient-to-br from-secondary/5 to-secondary/10 rounded-3xl border border-secondary/20">
              <h3 className="text-xl font-bold text-secondary mb-4">Our Key Partners</h3>
              <p className="text-secondary/70 mb-6">
                We work closely with government authorities, UN agencies, donors, and international organizations to ensure the NGO voice is heard and represented at all levels.
              </p>
              <div className="flex flex-wrap gap-4">
                <span className="px-4 py-2 bg-white rounded-full text-sm font-medium text-secondary border border-border">Government of South Sudan</span>
                <span className="px-4 py-2 bg-white rounded-full text-sm font-medium text-secondary border border-border">UN Agencies</span>
                <span className="px-4 py-2 bg-white rounded-full text-sm font-medium text-secondary border border-border">Donor Community</span>
                <span className="px-4 py-2 bg-white rounded-full text-sm font-medium text-secondary border border-border">Relief & Rehabilitation Commission</span>
              </div>
            </div>

            {/* Contact CTA */}
            <div className="mt-8 p-8 bg-gradient-to-br from-primary/5 to-primary/10 rounded-3xl border border-primary/20">
              <h3 className="text-xl font-bold text-secondary mb-4">Partner With Us</h3>
              <p className="text-secondary/70 mb-6">
                Interested in collaborating with the NGO Forum? We welcome partnerships that advance humanitarian and development outcomes in South Sudan.
              </p>
              <Link
                href="/contact"
                className="inline-flex items-center gap-2 px-6 py-3 bg-primary text-white rounded-xl font-semibold hover:bg-primary-light transition-colors"
              >
                Get in Touch
                <svg className="w-5 h-5" fill="none" viewBox="0 0 24 24" stroke="currentColor">
                  <path strokeLinecap="round" strokeLinejoin="round" strokeWidth={2} d="M17 8l4 4m0 0l-4 4m4-4H3" />
                </svg>
              </Link>
            </div>
          </div>
        </div>
      </section>
    </div>
  )
}
