# Generated by Django 5.0.1 on 2026-01-03 07:51

import django.db.models.deletion
from django.db import migrations, models


class Migration(migrations.Migration):

    initial = True

    dependencies = [
        ('members', '0001_initial'),
        ('operational', '0001_initial'),
    ]

    operations = [
        migrations.CreateModel(
            name='AccessConstraint',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('created_at', models.DateTimeField(auto_now_add=True)),
                ('updated_at', models.DateTimeField(auto_now=True)),
                ('reporter_name', models.CharField(max_length=200)),
                ('reporter_email', models.EmailField(max_length=254)),
                ('reporter_phone', models.CharField(blank=True, max_length=50)),
                ('location', models.CharField(max_length=255)),
                ('constraint_type', models.CharField(choices=[('BUREAUCRATIC', 'Bureaucratic'), ('PHYSICAL', 'Physical Access'), ('SECURITY', 'Security Related'), ('POLITICAL', 'Political'), ('OTHER', 'Other')], max_length=20)),
                ('description', models.TextField()),
                ('date_reported', models.DateField()),
                ('date_started', models.DateField(blank=True, help_text='When did the constraint start?', null=True)),
                ('affected_activities', models.TextField(blank=True, help_text='What activities are affected?')),
                ('estimated_impact', models.TextField(blank=True, help_text='Estimated impact on operations')),
                ('status', models.CharField(choices=[('ACTIVE', 'Active'), ('RESOLVED', 'Resolved'), ('MONITORING', 'Under Monitoring')], default='ACTIVE', max_length=20)),
                ('resolution_notes', models.TextField(blank=True)),
                ('resolved_date', models.DateField(blank=True, null=True)),
                ('county', models.ForeignKey(null=True, on_delete=django.db.models.deletion.SET_NULL, to='operational.county')),
                ('organization', models.ForeignKey(null=True, on_delete=django.db.models.deletion.SET_NULL, related_name='access_constraints', to='members.memberorganization')),
            ],
            options={
                'verbose_name': 'Access Constraint',
                'verbose_name_plural': 'Access Constraints',
                'ordering': ['-date_reported'],
            },
        ),
        migrations.CreateModel(
            name='SecurityIncident',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('created_at', models.DateTimeField(auto_now_add=True)),
                ('updated_at', models.DateTimeField(auto_now=True)),
                ('reporter_name', models.CharField(max_length=200)),
                ('reporter_email', models.EmailField(max_length=254)),
                ('reporter_phone', models.CharField(max_length=50)),
                ('who', models.CharField(help_text='Who was affected?', max_length=500)),
                ('where_location', models.CharField(help_text='Specific location/village', max_length=255)),
                ('when_date', models.DateField()),
                ('when_time', models.TimeField(blank=True, null=True)),
                ('what_happened', models.TextField(help_text='What happened? (detailed description)')),
                ('what_you_did', models.TextField(help_text='What actions did you take?')),
                ('what_you_need', models.TextField(help_text='What assistance/support do you need?')),
                ('incident_type', models.CharField(max_length=100)),
                ('severity', models.CharField(choices=[('LOW', 'Low'), ('MEDIUM', 'Medium'), ('HIGH', 'High'), ('CRITICAL', 'Critical')], default='MEDIUM', max_length=20)),
                ('status', models.CharField(choices=[('REPORTED', 'Reported'), ('INVESTIGATING', 'Under Investigation'), ('RESOLVED', 'Resolved'), ('CLOSED', 'Closed')], default='REPORTED', max_length=20)),
                ('is_confidential', models.BooleanField(default=False, help_text='Confidential reports are only visible to administrators')),
                ('follow_up_notes', models.TextField(blank=True)),
                ('resolved_date', models.DateTimeField(blank=True, null=True)),
                ('organization', models.ForeignKey(null=True, on_delete=django.db.models.deletion.SET_NULL, related_name='security_incidents', to='members.memberorganization')),
                ('where_county', models.ForeignKey(null=True, on_delete=django.db.models.deletion.SET_NULL, to='operational.county')),
                ('where_state', models.ForeignKey(null=True, on_delete=django.db.models.deletion.SET_NULL, to='operational.state')),
            ],
            options={
                'verbose_name': 'Security Incident',
                'verbose_name_plural': 'Security Incidents',
                'ordering': ['-when_date', '-created_at'],
            },
        ),
    ]
