# Generated by Django 5.0.1 on 2026-01-03 07:51

import django.core.validators
import django.db.models.deletion
import members.models
from django.db import migrations, models


class Migration(migrations.Migration):

    initial = True

    dependencies = [
        ('members', '0001_initial'),
    ]

    operations = [
        migrations.CreateModel(
            name='FAQCategory',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('name', models.CharField(max_length=200, unique=True)),
                ('slug', models.SlugField(blank=True, max_length=200, unique=True)),
                ('order', models.IntegerField(default=0)),
            ],
            options={
                'verbose_name': 'FAQ Category',
                'verbose_name_plural': 'FAQ Categories',
                'ordering': ['order', 'name'],
            },
        ),
        migrations.CreateModel(
            name='ResourceCategory',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('name', models.CharField(max_length=200, unique=True)),
                ('slug', models.SlugField(blank=True, max_length=200, unique=True)),
                ('description', models.TextField(blank=True)),
                ('icon', models.CharField(blank=True, help_text='CSS icon class or emoji', max_length=50)),
                ('order', models.IntegerField(default=0)),
            ],
            options={
                'verbose_name': 'Resource Category',
                'verbose_name_plural': 'Resource Categories',
                'ordering': ['order', 'name'],
            },
        ),
        migrations.CreateModel(
            name='FAQ',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('created_at', models.DateTimeField(auto_now_add=True)),
                ('updated_at', models.DateTimeField(auto_now=True)),
                ('question', models.CharField(max_length=500)),
                ('answer', models.TextField()),
                ('order', models.IntegerField(default=0)),
                ('is_published', models.BooleanField(default=True)),
                ('attachment', models.FileField(blank=True, upload_to='faqs/', validators=[django.core.validators.FileExtensionValidator(['pdf', 'doc', 'docx']), members.models.validate_file_size])),
                ('image', models.ImageField(blank=True, upload_to='faqs/images/', validators=[members.models.validate_file_size])),
                ('view_count', models.IntegerField(default=0)),
                ('category', models.ForeignKey(blank=True, null=True, on_delete=django.db.models.deletion.SET_NULL, related_name='faqs', to='resources.faqcategory')),
            ],
            options={
                'verbose_name': 'FAQ',
                'verbose_name_plural': 'FAQs',
                'ordering': ['order', '-created_at'],
            },
        ),
        migrations.CreateModel(
            name='Resource',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('created_at', models.DateTimeField(auto_now_add=True)),
                ('updated_at', models.DateTimeField(auto_now=True)),
                ('title', models.CharField(max_length=255)),
                ('slug', models.SlugField(blank=True, max_length=255, unique=True)),
                ('description', models.TextField()),
                ('resource_type', models.CharField(choices=[('DOCUMENT', 'Document'), ('TOOL', 'Tool/Platform'), ('LINK', 'External Link'), ('FORM', 'Form'), ('VIDEO', 'Video'), ('GUIDELINE', 'Guideline'), ('POLICY', 'Policy')], default='DOCUMENT', max_length=20)),
                ('file', models.FileField(blank=True, upload_to='resources/', validators=[members.models.validate_file_size])),
                ('external_url', models.URLField(blank=True)),
                ('thumbnail', models.ImageField(blank=True, upload_to='resources/thumbs/', validators=[members.models.validate_file_size])),
                ('order', models.IntegerField(default=0)),
                ('is_featured', models.BooleanField(default=False)),
                ('published_date', models.DateField()),
                ('is_approved', models.BooleanField(default=True)),
                ('download_count', models.IntegerField(default=0)),
                ('uploaded_by', models.ForeignKey(blank=True, null=True, on_delete=django.db.models.deletion.SET_NULL, related_name='uploaded_resources', to='members.memberorganization')),
                ('category', models.ForeignKey(null=True, on_delete=django.db.models.deletion.SET_NULL, related_name='resources', to='resources.resourcecategory')),
            ],
            options={
                'verbose_name': 'Resource',
                'verbose_name_plural': 'Resources',
                'ordering': ['-is_featured', 'order', '-published_date'],
            },
        ),
    ]
