# Generated by Django 5.0.1 on 2026-01-03 07:51

import django.core.validators
import django.db.models.deletion
from django.db import migrations, models


class Migration(migrations.Migration):

    initial = True

    dependencies = [
        ('members', '0001_initial'),
    ]

    operations = [
        migrations.CreateModel(
            name='Sector',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('name', models.CharField(max_length=100, unique=True)),
                ('description', models.TextField(blank=True)),
                ('color_code', models.CharField(blank=True, help_text='Hex color code (e.g., #FF5733)', max_length=7)),
            ],
            options={
                'verbose_name': 'Sector',
                'verbose_name_plural': 'Sectors',
                'ordering': ['name'],
            },
        ),
        migrations.CreateModel(
            name='State',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('name', models.CharField(max_length=100, unique=True)),
                ('code', models.CharField(blank=True, max_length=10)),
            ],
            options={
                'verbose_name': 'State',
                'verbose_name_plural': 'States',
                'ordering': ['name'],
            },
        ),
        migrations.CreateModel(
            name='County',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('name', models.CharField(max_length=100)),
                ('state', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, related_name='counties', to='operational.state')),
            ],
            options={
                'verbose_name': 'County',
                'verbose_name_plural': 'Counties',
                'ordering': ['state__name', 'name'],
                'unique_together': {('name', 'state')},
            },
        ),
        migrations.CreateModel(
            name='OperationalPresence',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('year', models.IntegerField(validators=[django.core.validators.MinValueValidator(2010), django.core.validators.MaxValueValidator(2030)])),
                ('presence_count', models.IntegerField(default=1, help_text='Number of projects/activities')),
                ('is_active', models.BooleanField(default=True)),
                ('notes', models.TextField(blank=True)),
                ('created_at', models.DateTimeField(auto_now_add=True)),
                ('updated_at', models.DateTimeField(auto_now=True)),
                ('county', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, related_name='presences', to='operational.county')),
                ('organization', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, related_name='operational_presence', to='members.memberorganization')),
                ('sector', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, related_name='presences', to='operational.sector')),
            ],
            options={
                'verbose_name': 'Operational Presence',
                'verbose_name_plural': 'Operational Presences',
                'ordering': ['-year', 'organization__name'],
                'unique_together': {('organization', 'sector', 'county', 'year')},
            },
        ),
    ]
