from django.urls import path, include
from rest_framework.routers import DefaultRouter
from .views import (
    PublicMemberViewSet, MemberProfileViewSet, StaffMemberViewSet,
    MembershipApplicationViewSet, MembershipPaymentViewSet,
    MoMoCallbackView, InitiatePaymentView, CheckPaymentStatusView, setup_momo_sandbox,
    MemberStatusView
)

router = DefaultRouter()
router.register(r'public/members', PublicMemberViewSet, basename='public-member')
router.register(r'profile', MemberProfileViewSet, basename='member-profile')
router.register(r'staff', StaffMemberViewSet, basename='staff')
router.register(r'applications', MembershipApplicationViewSet, basename='membership-application')
router.register(r'payments', MembershipPaymentViewSet, basename='membership-payment')

urlpatterns = [
    # Router URLs
    path('', include(router.urls)),
    
    # Member status endpoint (dashboard data)
    path('status/', MemberStatusView.as_view(), name='member-status'),
    
    # MTN Mobile Money endpoints
    path('momo/callback/', MoMoCallbackView.as_view(), name='momo-callback'),
    path('momo/initiate/', InitiatePaymentView.as_view(), name='momo-initiate'),
    path('momo/status/<str:external_id>/', CheckPaymentStatusView.as_view(), name='momo-status'),
    path('momo/setup-sandbox/', setup_momo_sandbox, name='momo-setup-sandbox'),
]
