# Generated by Django 5.0.1 on 2026-01-19 15:44

import django.db.models.deletion
from django.db import migrations, models


class Migration(migrations.Migration):

    dependencies = [
        ('members', '0002_update_membership_application'),
    ]

    operations = [
        migrations.AlterField(
            model_name='membershipapplication',
            name='application_status',
            field=models.CharField(choices=[('DRAFT', 'Draft'), ('PENDING', 'Pending Review'), ('STEERING_COMMITTEE', 'Steering Committee Review'), ('COUNTRY_DIRECTORS', 'Country Directors Vote'), ('PENDING_PAYMENT', 'Pending Payment'), ('APPROVED', 'Approved'), ('REJECTED', 'Rejected')], default='DRAFT', max_length=30),
        ),
        migrations.CreateModel(
            name='MoMoPaymentRequest',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('created_at', models.DateTimeField(auto_now_add=True)),
                ('updated_at', models.DateTimeField(auto_now=True)),
                ('amount', models.DecimalField(decimal_places=2, default=200.0, max_digits=10)),
                ('currency', models.CharField(default='USD', max_length=3)),
                ('payer_phone', models.CharField(help_text='Phone number in format 256xxxxxxxxx', max_length=20)),
                ('payer_message', models.TextField(blank=True)),
                ('payee_note', models.TextField(blank=True)),
                ('external_id', models.CharField(help_text='Our reference ID', max_length=100, unique=True)),
                ('reference_id', models.UUIDField(blank=True, help_text='MTN API request reference', null=True)),
                ('financial_transaction_id', models.CharField(blank=True, help_text='MTN financial transaction ID', max_length=100)),
                ('status', models.CharField(choices=[('PENDING', 'Pending'), ('SUCCESSFUL', 'Successful'), ('FAILED', 'Failed'), ('CANCELLED', 'Cancelled'), ('TIMEOUT', 'Timeout')], default='PENDING', max_length=20)),
                ('status_reason', models.TextField(blank=True)),
                ('requested_at', models.DateTimeField(auto_now_add=True)),
                ('completed_at', models.DateTimeField(blank=True, null=True)),
                ('application', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, related_name='momo_payments', to='members.membershipapplication')),
            ],
            options={
                'verbose_name': 'MoMo Payment Request',
                'verbose_name_plural': 'MoMo Payment Requests',
                'ordering': ['-created_at'],
            },
        ),
    ]
