# Generated by Django 5.0.1 on 2026-01-18 08:32

import django.core.validators
import django.db.models.deletion
import members.models
from django.conf import settings
from django.db import migrations, models


class Migration(migrations.Migration):

    dependencies = [
        ('members', '0001_initial'),
        migrations.swappable_dependency(settings.AUTH_USER_MODEL),
    ]

    operations = [
        migrations.AlterModelOptions(
            name='membershipapplication',
            options={'ordering': ['-submitted_date', '-created_at'], 'verbose_name': 'Membership Application', 'verbose_name_plural': 'Membership Applications'},
        ),
        migrations.RemoveField(
            model_name='membershipapplication',
            name='address',
        ),
        migrations.RemoveField(
            model_name='membershipapplication',
            name='areas_of_work',
        ),
        migrations.RemoveField(
            model_name='membershipapplication',
            name='email',
        ),
        migrations.RemoveField(
            model_name='membershipapplication',
            name='focal_person_email',
        ),
        migrations.RemoveField(
            model_name='membershipapplication',
            name='focal_person_name',
        ),
        migrations.RemoveField(
            model_name='membershipapplication',
            name='focal_person_phone',
        ),
        migrations.RemoveField(
            model_name='membershipapplication',
            name='focal_person_title',
        ),
        migrations.RemoveField(
            model_name='membershipapplication',
            name='operational_counties',
        ),
        migrations.RemoveField(
            model_name='membershipapplication',
            name='phone',
        ),
        migrations.RemoveField(
            model_name='membershipapplication',
            name='rrc_registration',
        ),
        migrations.RemoveField(
            model_name='membershipapplication',
            name='supporting_documents',
        ),
        migrations.AddField(
            model_name='membershipapplication',
            name='annual_operating_budget_usd',
            field=models.DecimalField(blank=True, decimal_places=2, max_digits=15, null=True),
        ),
        migrations.AddField(
            model_name='membershipapplication',
            name='application_id',
            field=models.CharField(blank=True, max_length=20, unique=True),
        ),
        migrations.AddField(
            model_name='membershipapplication',
            name='clusters_sectors',
            field=models.JSONField(default=list, help_text='List of clusters/sectors'),
        ),
        migrations.AddField(
            model_name='membershipapplication',
            name='codes_of_conduct',
            field=models.JSONField(blank=True, default=list, help_text='List of codes organization is signatory to'),
        ),
        migrations.AddField(
            model_name='membershipapplication',
            name='global_networks',
            field=models.JSONField(blank=True, default=list, help_text='List of global networks organization is part of'),
        ),
        migrations.AddField(
            model_name='membershipapplication',
            name='has_fulltime_presence',
            field=models.BooleanField(default=False),
        ),
        migrations.AddField(
            model_name='membershipapplication',
            name='headquarter_country',
            field=models.CharField(default='South Sudan', max_length=100),
        ),
        migrations.AddField(
            model_name='membershipapplication',
            name='international_staff_count',
            field=models.IntegerField(default=0),
        ),
        migrations.AddField(
            model_name='membershipapplication',
            name='invoicing_contact_email',
            field=models.EmailField(default='', max_length=254),
        ),
        migrations.AddField(
            model_name='membershipapplication',
            name='invoicing_contact_name',
            field=models.CharField(default='', max_length=200),
        ),
        migrations.AddField(
            model_name='membershipapplication',
            name='invoicing_contact_phone',
            field=models.CharField(default='', max_length=50),
        ),
        migrations.AddField(
            model_name='membershipapplication',
            name='is_humanitarian_actor',
            field=models.BooleanField(default=False),
        ),
        migrations.AddField(
            model_name='membershipapplication',
            name='is_non_political',
            field=models.BooleanField(default=False),
        ),
        migrations.AddField(
            model_name='membershipapplication',
            name='is_non_proselytising',
            field=models.BooleanField(default=False),
        ),
        migrations.AddField(
            model_name='membershipapplication',
            name='is_woman_led',
            field=models.CharField(choices=[('YES', 'Yes'), ('NO', 'No')], default='NO', max_length=10),
        ),
        migrations.AddField(
            model_name='membershipapplication',
            name='juba_residence_compound',
            field=models.CharField(blank=True, default='', max_length=255),
        ),
        migrations.AddField(
            model_name='membershipapplication',
            name='mailing_list_contacts',
            field=models.JSONField(blank=True, default=list, help_text='List of contacts for mailing lists'),
        ),
        migrations.AddField(
            model_name='membershipapplication',
            name='national_staff_count',
            field=models.IntegerField(default=0),
        ),
        migrations.AddField(
            model_name='membershipapplication',
            name='ngo_vehicle_plate_prefix',
            field=models.CharField(blank=True, default='', max_length=20),
        ),
        migrations.AddField(
            model_name='membershipapplication',
            name='operational_presence',
            field=models.JSONField(default=dict, help_text='Dict mapping cluster to list of counties'),
        ),
        migrations.AddField(
            model_name='membershipapplication',
            name='organization_acronym',
            field=models.CharField(default='', max_length=50),
        ),
        migrations.AddField(
            model_name='membershipapplication',
            name='organization_brief',
            field=models.TextField(default='', help_text='Short brief of your organization'),
        ),
        migrations.AddField(
            model_name='membershipapplication',
            name='psea_policy',
            field=models.CharField(choices=[('YES', 'Yes'), ('NO', 'No'), ('WORKING', 'We are working on it'), ('UNKNOWN', "I Don't Know")], default='UNKNOWN', max_length=20),
        ),
        migrations.AddField(
            model_name='membershipapplication',
            name='relocatable_staff_count',
            field=models.IntegerField(default=0),
        ),
        migrations.AddField(
            model_name='membershipapplication',
            name='reviewer',
            field=models.ForeignKey(blank=True, null=True, on_delete=django.db.models.deletion.SET_NULL, related_name='reviewed_applications', to=settings.AUTH_USER_MODEL),
        ),
        migrations.AddField(
            model_name='membershipapplication',
            name='rrc_certificate_expiry_date',
            field=models.DateField(blank=True, null=True),
        ),
        migrations.AddField(
            model_name='membershipapplication',
            name='rrc_certificate_start_date',
            field=models.DateField(blank=True, null=True),
        ),
        migrations.AddField(
            model_name='membershipapplication',
            name='rrc_registration_number',
            field=models.CharField(default='', max_length=100),
        ),
        migrations.AddField(
            model_name='membershipapplication',
            name='ss_hq_physical_address',
            field=models.TextField(default=''),
        ),
        migrations.AddField(
            model_name='membershipapplication',
            name='ss_main_office_state',
            field=models.CharField(default='Central Equatoria', max_length=100),
        ),
        migrations.AddField(
            model_name='membershipapplication',
            name='year_operations_began',
            field=models.IntegerField(default=2020),
        ),
        migrations.AlterField(
            model_name='membershipapplication',
            name='application_status',
            field=models.CharField(choices=[('DRAFT', 'Draft'), ('PENDING', 'Pending Review'), ('STEERING_COMMITTEE', 'Steering Committee Review'), ('COUNTRY_DIRECTORS', 'Country Directors Vote'), ('APPROVED', 'Approved'), ('REJECTED', 'Rejected')], default='DRAFT', max_length=30),
        ),
        migrations.AlterField(
            model_name='membershipapplication',
            name='organization_type',
            field=models.CharField(choices=[('INGO', 'International NGO'), ('NNGO', 'National NGO'), ('OBSERVER', 'Observer')], default='NNGO', max_length=20),
        ),
        migrations.AlterField(
            model_name='membershipapplication',
            name='rrc_certificate',
            field=models.ImageField(blank=True, help_text='Upload RRC Certificate (2MB max, jpeg/png)', null=True, upload_to='applications/certificates/', validators=[django.core.validators.FileExtensionValidator(['jpg', 'jpeg', 'png']), members.models.validate_file_size]),
        ),
        migrations.AlterField(
            model_name='membershipapplication',
            name='submitted_date',
            field=models.DateTimeField(blank=True, null=True),
        ),
        migrations.AlterField(
            model_name='membershipapplication',
            name='website',
            field=models.URLField(blank=True, default=''),
        ),
    ]
