# Generated by Django 5.0.1 on 2026-01-03 07:51

import django.core.validators
import django.db.models.deletion
import members.models
from django.conf import settings
from django.db import migrations, models


class Migration(migrations.Migration):

    initial = True

    dependencies = [
        migrations.swappable_dependency(settings.AUTH_USER_MODEL),
    ]

    operations = [
        migrations.CreateModel(
            name='StaffMember',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('created_at', models.DateTimeField(auto_now_add=True)),
                ('updated_at', models.DateTimeField(auto_now=True)),
                ('name', models.CharField(max_length=200)),
                ('position', models.CharField(max_length=200)),
                ('email', models.EmailField(max_length=254)),
                ('phone', models.CharField(blank=True, max_length=50)),
                ('bio', models.TextField(blank=True)),
                ('photo', models.ImageField(blank=True, upload_to='staff/', validators=[members.models.validate_file_size])),
                ('order', models.IntegerField(default=0, help_text='Display order (lower numbers first)')),
                ('is_active', models.BooleanField(default=True)),
            ],
            options={
                'verbose_name': 'Staff Member',
                'verbose_name_plural': 'Staff Members',
                'ordering': ['order', 'name'],
            },
        ),
        migrations.CreateModel(
            name='MemberOrganization',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('created_at', models.DateTimeField(auto_now_add=True)),
                ('updated_at', models.DateTimeField(auto_now=True)),
                ('name', models.CharField(max_length=255)),
                ('slug', models.SlugField(blank=True, max_length=255, unique=True)),
                ('member_type', models.CharField(choices=[('NATIONAL', 'National NGO'), ('INTERNATIONAL', 'International NGO')], max_length=20)),
                ('rrc_number', models.CharField(blank=True, help_text='RRC Registration Number', max_length=100)),
                ('registration_date', models.DateField(blank=True, null=True)),
                ('email', models.EmailField(max_length=254)),
                ('phone', models.CharField(blank=True, max_length=50)),
                ('website', models.URLField(blank=True)),
                ('address', models.TextField()),
                ('city', models.CharField(default='Juba', max_length=100)),
                ('state', models.CharField(blank=True, max_length=100)),
                ('description', models.TextField(blank=True)),
                ('logo', models.ImageField(blank=True, upload_to='logos/', validators=[members.models.validate_file_size])),
                ('status', models.CharField(choices=[('ACTIVE', 'Active'), ('PENDING', 'Pending'), ('INACTIVE', 'Inactive'), ('SUSPENDED', 'Suspended')], default='PENDING', max_length=20)),
                ('date_joined', models.DateField(auto_now_add=True)),
                ('is_verified', models.BooleanField(default=False, help_text='Verified members get auto-approval for content')),
                ('auto_approve_content', models.BooleanField(default=False)),
                ('membership_fee_paid', models.BooleanField(default=False)),
                ('membership_expiry_date', models.DateField(blank=True, null=True)),
                ('user', models.OneToOneField(blank=True, null=True, on_delete=django.db.models.deletion.SET_NULL, related_name='member_organization', to=settings.AUTH_USER_MODEL)),
            ],
            options={
                'verbose_name': 'Member Organization',
                'verbose_name_plural': 'Member Organizations',
                'ordering': ['name'],
            },
        ),
        migrations.CreateModel(
            name='MembershipApplication',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('created_at', models.DateTimeField(auto_now_add=True)),
                ('updated_at', models.DateTimeField(auto_now=True)),
                ('organization_name', models.CharField(max_length=255)),
                ('organization_type', models.CharField(choices=[('NATIONAL', 'National NGO'), ('INTERNATIONAL', 'International NGO')], max_length=20)),
                ('rrc_registration', models.CharField(help_text='RRC Registration Number', max_length=100)),
                ('rrc_certificate', models.FileField(upload_to='applications/certificates/', validators=[django.core.validators.FileExtensionValidator(['pdf', 'jpg', 'jpeg', 'png']), members.models.validate_file_size])),
                ('address', models.TextField()),
                ('email', models.EmailField(max_length=254)),
                ('phone', models.CharField(max_length=50)),
                ('website', models.URLField(blank=True)),
                ('focal_person_name', models.CharField(max_length=200)),
                ('focal_person_title', models.CharField(max_length=200)),
                ('focal_person_email', models.EmailField(max_length=254)),
                ('focal_person_phone', models.CharField(max_length=50)),
                ('areas_of_work', models.TextField(help_text="Describe your organization's areas of work")),
                ('operational_counties', models.TextField(help_text='List counties where your organization operates')),
                ('supporting_documents', models.FileField(blank=True, upload_to='applications/docs/', validators=[django.core.validators.FileExtensionValidator(['pdf', 'zip']), members.models.validate_file_size])),
                ('application_status', models.CharField(choices=[('PENDING', 'Pending Review'), ('UNDER_REVIEW', 'Under Review'), ('APPROVED', 'Approved'), ('REJECTED', 'Rejected')], default='PENDING', max_length=20)),
                ('submitted_date', models.DateTimeField(auto_now_add=True)),
                ('reviewed_date', models.DateTimeField(blank=True, null=True)),
                ('reviewer_notes', models.TextField(blank=True)),
                ('approved_organization', models.OneToOneField(blank=True, null=True, on_delete=django.db.models.deletion.SET_NULL, related_name='application', to='members.memberorganization')),
            ],
            options={
                'verbose_name': 'Membership Application',
                'verbose_name_plural': 'Membership Applications',
                'ordering': ['-submitted_date'],
            },
        ),
        migrations.CreateModel(
            name='MembershipPayment',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('created_at', models.DateTimeField(auto_now_add=True)),
                ('updated_at', models.DateTimeField(auto_now=True)),
                ('amount', models.DecimalField(decimal_places=2, default=200.0, max_digits=10)),
                ('payment_date', models.DateField(auto_now_add=True)),
                ('transaction_reference', models.CharField(blank=True, max_length=255)),
                ('payment_method', models.CharField(blank=True, max_length=100)),
                ('status', models.CharField(choices=[('PENDING', 'Pending'), ('COMPLETED', 'Completed'), ('FAILED', 'Failed'), ('REFUNDED', 'Refunded')], default='PENDING', max_length=20)),
                ('receipt', models.FileField(blank=True, upload_to='payments/receipts/', validators=[django.core.validators.FileExtensionValidator(['pdf', 'jpg', 'jpeg', 'png']), members.models.validate_file_size])),
                ('notes', models.TextField(blank=True)),
                ('organization', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, related_name='payments', to='members.memberorganization')),
            ],
            options={
                'verbose_name': 'Membership Payment',
                'verbose_name_plural': 'Membership Payments',
                'ordering': ['-payment_date'],
            },
        ),
        migrations.CreateModel(
            name='OrganizationContact',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('created_at', models.DateTimeField(auto_now_add=True)),
                ('updated_at', models.DateTimeField(auto_now=True)),
                ('name', models.CharField(max_length=200)),
                ('title', models.CharField(max_length=200)),
                ('email', models.EmailField(max_length=254)),
                ('phone', models.CharField(max_length=50)),
                ('is_primary', models.BooleanField(default=False)),
                ('organization', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, related_name='contacts', to='members.memberorganization')),
            ],
            options={
                'verbose_name': 'Organization Contact',
                'verbose_name_plural': 'Organization Contacts',
                'ordering': ['-is_primary', 'name'],
            },
        ),
    ]
