from django.core.management.base import BaseCommand
from members.momo_service import get_momo_service


class Command(BaseCommand):
    help = 'Setup MTN MoMo sandbox credentials (API User and API Key)'

    def handle(self, *args, **options):
        self.stdout.write('Setting up MTN MoMo sandbox credentials...\n')
        
        momo = get_momo_service()
        result = momo.setup_sandbox()
        
        if result['success']:
            self.stdout.write(self.style.SUCCESS('\n✓ Sandbox credentials generated successfully!\n'))
            self.stdout.write('\nAdd these to your .env file:\n')
            self.stdout.write(self.style.WARNING(f"MOMO_API_USER_ID={result['api_user_id']}"))
            self.stdout.write(self.style.WARNING(f"MOMO_API_KEY={result['api_key']}"))
            self.stdout.write('\nThen restart the Django server.\n')
        else:
            self.stdout.write(self.style.ERROR(f"\n✗ Failed to setup sandbox: {result.get('error')}"))
