# Generated by Django 5.0.1 on 2026-01-03 07:51

import django.core.validators
import django.db.models.deletion
import members.models
from django.db import migrations, models


class Migration(migrations.Migration):

    initial = True

    dependencies = [
        ('members', '0001_initial'),
    ]

    operations = [
        migrations.CreateModel(
            name='JobAdvertisement',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('created_at', models.DateTimeField(auto_now_add=True)),
                ('updated_at', models.DateTimeField(auto_now=True)),
                ('job_title', models.CharField(max_length=255)),
                ('location', models.CharField(max_length=255)),
                ('job_type', models.CharField(choices=[('FULL_TIME', 'Full Time'), ('PART_TIME', 'Part Time'), ('CONTRACT', 'Contract'), ('INTERNSHIP', 'Internship'), ('VOLUNTEER', 'Volunteer'), ('CONSULTANT', 'Consultant')], default='FULL_TIME', max_length=20)),
                ('description', models.TextField()),
                ('requirements', models.TextField()),
                ('responsibilities', models.TextField(blank=True)),
                ('qualifications', models.TextField(blank=True)),
                ('application_deadline', models.DateField()),
                ('application_email', models.EmailField(max_length=254)),
                ('application_url', models.URLField(blank=True)),
                ('application_instructions', models.TextField(blank=True)),
                ('salary_range', models.CharField(blank=True, max_length=100)),
                ('posted_date', models.DateField(auto_now_add=True)),
                ('is_active', models.BooleanField(default=True)),
                ('is_approved', models.BooleanField(default=True)),
                ('view_count', models.IntegerField(default=0)),
                ('organization', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, related_name='job_advertisements', to='members.memberorganization')),
            ],
            options={
                'verbose_name': 'Job Advertisement',
                'verbose_name_plural': 'Job Advertisements',
                'ordering': ['-posted_date'],
            },
        ),
        migrations.CreateModel(
            name='TenderAdvertisement',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('created_at', models.DateTimeField(auto_now_add=True)),
                ('updated_at', models.DateTimeField(auto_now=True)),
                ('title', models.CharField(max_length=255)),
                ('reference_number', models.CharField(max_length=100, unique=True)),
                ('description', models.TextField()),
                ('category', models.CharField(help_text='e.g., Goods, Services, Works, Consultancy', max_length=200)),
                ('submission_deadline', models.DateTimeField()),
                ('opening_date', models.DateTimeField(blank=True, null=True)),
                ('contact_person', models.CharField(max_length=200)),
                ('contact_email', models.EmailField(max_length=254)),
                ('contact_phone', models.CharField(blank=True, max_length=50)),
                ('document', models.FileField(blank=True, upload_to='tenders/', validators=[django.core.validators.FileExtensionValidator(['pdf', 'doc', 'docx']), members.models.validate_file_size])),
                ('external_link', models.URLField(blank=True, help_text='Link to tender document or details')),
                ('posted_date', models.DateField(auto_now_add=True)),
                ('is_active', models.BooleanField(default=True)),
                ('is_approved', models.BooleanField(default=True)),
                ('organization', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, related_name='tender_advertisements', to='members.memberorganization')),
            ],
            options={
                'verbose_name': 'Tender Advertisement',
                'verbose_name_plural': 'Tender Advertisements',
                'ordering': ['-submission_deadline'],
            },
        ),
        migrations.CreateModel(
            name='Training',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('created_at', models.DateTimeField(auto_now_add=True)),
                ('updated_at', models.DateTimeField(auto_now=True)),
                ('title', models.CharField(max_length=255)),
                ('provider', models.CharField(help_text='Training provider/organization', max_length=255)),
                ('description', models.TextField()),
                ('start_date', models.DateField()),
                ('end_date', models.DateField(blank=True, null=True)),
                ('location', models.CharField(max_length=255)),
                ('is_online', models.BooleanField(default=False)),
                ('cost', models.DecimalField(blank=True, decimal_places=2, max_digits=10, null=True)),
                ('currency', models.CharField(default='USD', max_length=3)),
                ('is_free', models.BooleanField(default=False)),
                ('registration_link', models.URLField(blank=True)),
                ('registration_deadline', models.DateField(blank=True, null=True)),
                ('contact_email', models.EmailField(max_length=254)),
                ('contact_phone', models.CharField(blank=True, max_length=50)),
                ('max_participants', models.IntegerField(blank=True, null=True)),
                ('posted_date', models.DateField(auto_now_add=True)),
                ('is_active', models.BooleanField(default=True)),
                ('is_approved', models.BooleanField(default=True)),
                ('submitted_by', models.ForeignKey(blank=True, null=True, on_delete=django.db.models.deletion.SET_NULL, related_name='submitted_trainings', to='members.memberorganization')),
            ],
            options={
                'verbose_name': 'Training',
                'verbose_name_plural': 'Trainings',
                'ordering': ['start_date'],
            },
        ),
    ]
