# Generated by Django 5.0.1 on 2026-01-03 07:51

import django.db.models.deletion
import members.models
from django.db import migrations, models


class Migration(migrations.Migration):

    initial = True

    dependencies = [
        ('members', '0001_initial'),
    ]

    operations = [
        migrations.CreateModel(
            name='Event',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('created_at', models.DateTimeField(auto_now_add=True)),
                ('updated_at', models.DateTimeField(auto_now=True)),
                ('title', models.CharField(max_length=255)),
                ('slug', models.SlugField(blank=True, max_length=255, unique=True)),
                ('theme', models.CharField(blank=True, max_length=500)),
                ('description', models.TextField()),
                ('event_date', models.DateField()),
                ('event_time', models.TimeField(blank=True, null=True)),
                ('end_date', models.DateField(blank=True, null=True)),
                ('location', models.CharField(max_length=255)),
                ('venue', models.CharField(blank=True, max_length=255)),
                ('event_type', models.CharField(choices=[('CONFERENCE', 'Conference'), ('WORKSHOP', 'Workshop'), ('TRAINING', 'Training'), ('EXPO', 'Expo'), ('MEETING', 'Meeting'), ('WEBINAR', 'Webinar'), ('OTHER', 'Other')], default='MEETING', max_length=20)),
                ('status', models.CharField(choices=[('UPCOMING', 'Upcoming'), ('ONGOING', 'Ongoing'), ('PAST', 'Past'), ('CANCELLED', 'Cancelled')], default='UPCOMING', max_length=20)),
                ('registration_required', models.BooleanField(default=False)),
                ('registration_link', models.URLField(blank=True)),
                ('max_attendees', models.IntegerField(blank=True, null=True)),
                ('featured_image', models.ImageField(blank=True, upload_to='events/', validators=[members.models.validate_file_size])),
                ('attachments', models.FileField(blank=True, upload_to='events/docs/', validators=[members.models.validate_file_size])),
                ('is_approved', models.BooleanField(default=True)),
                ('created_by', models.ForeignKey(blank=True, null=True, on_delete=django.db.models.deletion.SET_NULL, related_name='organized_events', to='members.memberorganization')),
            ],
            options={
                'verbose_name': 'Event',
                'verbose_name_plural': 'Events',
                'ordering': ['-event_date'],
            },
        ),
        migrations.CreateModel(
            name='EventAttendance',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('created_at', models.DateTimeField(auto_now_add=True)),
                ('updated_at', models.DateTimeField(auto_now=True)),
                ('attendee_name', models.CharField(max_length=200)),
                ('attendee_email', models.EmailField(max_length=254)),
                ('attendee_phone', models.CharField(blank=True, max_length=50)),
                ('registered_at', models.DateTimeField(auto_now_add=True)),
                ('attended', models.BooleanField(default=False)),
                ('notes', models.TextField(blank=True)),
                ('event', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, related_name='attendances', to='events.event')),
                ('organization', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, related_name='event_attendances', to='members.memberorganization')),
            ],
            options={
                'verbose_name': 'Event Attendance',
                'verbose_name_plural': 'Event Attendances',
                'ordering': ['-registered_at'],
                'unique_together': {('event', 'attendee_email')},
            },
        ),
    ]
